/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2020 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */
#pragma once

//
// lcd/dogm/status/fan.h - Status Screen Fan bitmaps
//

#undef STATUS_FAN_WIDTH
#define STATUS_FAN_WIDTH 20

#if STATUS_FAN_FRAMES <= 2

  #define STATUS_FAN_Y 2

  #if ENABLED(STATUS_ALT_FAN_BITMAP)

    const unsigned char status_fan0_bmp[] PROGMEM = {
      B00000001,B11111110,B00000000,
      B00000110,B00000001,B10000000,
      B00001000,B11111100,B01000000,
      B00010000,B11111100,B00100000,
      B00010000,B01111000,B00100000,
      B00100000,B00110000,B00010000,
      B00101100,B00000000,B11010000,
      B00101110,B00110001,B11010000,
      B00101111,B01111011,B11010000,
      B00101111,B01111011,B11010000,
      B00101110,B00110001,B11010000,
      B00101100,B00000000,B11010000,
      B00100000,B00110000,B00010000,
      B00010000,B01111000,B00100000,
      B00010000,B11111100,B00100000,
      B00001000,B11111100,B01000000,
      B00000110,B00000001,B10000000,
      B00000001,B11111110,B00000000
    };

    #if STATUS_FAN_FRAMES == 2
      const unsigned char status_fan1_bmp[] PROGMEM = {
        B00000001,B11111110,B00000000,
        B00000110,B00000001,B10000000,
        B00001001,B10000110,B01000000,
        B00010011,B10000111,B00100000,
        B00010111,B10000111,B10100000,
        B00101111,B10000111,B11010000,
        B00101111,B00000011,B11010000,
        B00100000,B00110000,B00010000,
        B00100000,B01111000,B00010000,
        B00100000,B01111000,B00010000,
        B00100000,B00110000,B00010000,
        B00101111,B00000011,B11010000,
        B00101111,B10000111,B11010000,
        B00010111,B10000111,B10100000,
        B00010011,B10000111,B00100000,
        B00001001,B10000110,B01000000,
        B00000110,B00000001,B10000000,
        B00000001,B11111110,B00000000
      };
    #endif

  #else // !STATUS_ALT_FAN_BITMAP

    const unsigned char status_fan0_bmp[] PROGMEM = {
      B00111111,B11111111,B11110000,
      B00111000,B00000000,B01110000,
      B00110000,B11111100,B00110000,
      B00100000,B11111100,B00010000,
      B00100000,B01111000,B00010000,
      B00100000,B00110000,B00010000,
      B00101100,B00000000,B11010000,
      B00101110,B00110001,B11010000,
      B00101111,B01111011,B11010000,
      B00101111,B01111011,B11010000,
      B00101110,B00110001,B11010000,
      B00101100,B00000000,B11010000,
      B00100000,B00110000,B00010000,
      B00100000,B01111000,B00010000,
      B00100000,B11111100,B00010000,
      B00110000,B11111100,B00110000,
      B00111000,B00000000,B01110000,
      B00111111,B11111111,B11110000
    };

    #if STATUS_FAN_FRAMES == 2
      const unsigned char status_fan1_bmp[] PROGMEM = {
        B00111111,B11111111,B11110000,
        B00111000,B00000000,B01110000,
        B00110001,B10000110,B00110000,
        B00100011,B10000111,B00010000,
        B00100111,B10000111,B10010000,
        B00101111,B10000111,B11010000,
        B00101111,B00000011,B11010000,
        B00100000,B00110000,B00010000,
        B00100000,B01111000,B00010000,
        B00100000,B01111000,B00010000,
        B00100000,B00110000,B00010000,
        B00101111,B00000011,B11010000,
        B00101111,B10000111,B11010000,
        B00100111,B10000111,B10010000,
        B00100011,B10000111,B00010000,
        B00110001,B10000110,B00110000,
        B00111000,B00000000,B01110000,
        B00111111,B11111111,B11110000
      };
    #endif

  #endif // !STATUS_ALT_FAN_BITMAP

#elif STATUS_FAN_FRAMES == 3

  #if ENABLED(STATUS_ALT_FAN_BITMAP)

    const unsigned char status_fan0_bmp[] PROGMEM = {
      B00000001,B11111111,B00000000,
      B00000110,B00000000,B11000000,
      B00001001,B00000001,B00100000,
      B00010111,B10000011,B11010000,
      B00010111,B10000011,B11010000,
      B00101111,B11000111,B11101000,
      B00100111,B11000111,B11001000,
      B00100001,B11111111,B00001000,
      B00100000,B01111100,B00001000,
      B00100000,B01111100,B00001000,
      B00100000,B01111100,B00001000,
      B00100001,B11111111,B00001000,
      B00100111,B11000111,B11001000,
      B00101111,B11000111,B11101000,
      B00010111,B10000011,B11010000,
      B00010111,B10000011,B11010000,
      B00001001,B00000001,B00100000,
      B00000110,B00000000,B11000000,
      B00000001,B11111111,B00000000
    };
    const unsigned char status_fan1_bmp[] PROGMEM = {
      B00000001,B11111111,B00000000,
      B00000110,B00110000,B11000000,
      B00001001,B11110000,B00100000,
      B00010001,B11110000,B00010000,
      B00010000,B11110000,B00010000,
      B00100000,B11110000,B01101000,
      B00100000,B00110001,B11101000,
      B00100000,B00111001,B11101000,
      B00100000,B01111111,B11111000,
      B00111111,B11111111,B11111000,
      B00111111,B11111100,B00001000,
      B00101111,B00111000,B00001000,
      B00101110,B00011000,B00001000,
      B00101100,B00011110,B00001000,
      B00010000,B00011110,B00010000,
      B00010000,B00011111,B00010000,
      B00001000,B00011111,B00100000,
      B00000110,B00011000,B11000000,
      B00000001,B11111111,B00000000
    };
    const unsigned char status_fan2_bmp[] PROGMEM = {
      B00000001,B11111111,B00000000,
      B00000110,B00011000,B11000000,
      B00001000,B00011111,B00100000,
      B00010000,B00011111,B10010000,
      B00010100,B00011111,B00010000,
      B00101110,B00011110,B00001000,
      B00101111,B00011100,B00001000,
      B00101111,B10111000,B00001000,
      B00111111,B11111100,B00001000,
      B00111111,B11111111,B11111000,
      B00100000,B01111111,B11111000,
      B00100000,B00111011,B11101000,
      B00100000,B01110001,B11101000,
      B00100000,B11110000,B11101000,
      B00010001,B11110000,B01010000,
      B00010011,B11110000,B00010000,
      B00001001,B11110000,B00100000,
      B00000110,B00110000,B11000000,
      B00000001,B11111111,B00000000
    };

  #else // !STATUS_ALT_FAN_BITMAP

    const unsigned char status_fan0_bmp[] PROGMEM = {
      B00111111,B11111111,B11111000,
      B00111110,B00000000,B11111000,
      B00111001,B00000001,B00111000,
      B00110111,B10000011,B11011000,
      B00110111,B10000011,B11011000,
      B00101111,B11000111,B11101000,
      B00100111,B11000111,B11001000,
      B00100001,B11111111,B00001000,
      B00100000,B01111100,B00001000,
      B00100000,B01111100,B00001000,
      B00100000,B01111100,B00001000,
      B00100001,B11111111,B00001000,
      B00100111,B11000111,B11001000,
      B00101111,B11000111,B11101000,
      B00110111,B10000011,B11011000,
      B00110111,B10000011,B11011000,
      B00111001,B00000001,B00111000,
      B00111110,B00000000,B11111000,
      B00111111,B11111111,B11111000
    };
    const unsigned char status_fan1_bmp[] PROGMEM = {
      B00111111,B11111111,B11111000,
      B00111110,B00110000,B11111000,
      B00111001,B11110000,B00111000,
      B00110001,B11110000,B00011000,
      B00110000,B11110000,B00011000,
      B00100000,B11110000,B01101000,
      B00100000,B00110001,B11101000,
      B00100000,B00111001,B11101000,
      B00100000,B01111111,B11111000,
      B00111111,B11111111,B11111000,
      B00111111,B11111100,B00001000,
      B00101111,B00111000,B00001000,
      B00101110,B00011000,B00001000,
      B00101100,B00011110,B00001000,
      B00110000,B00011110,B00011000,
      B00110000,B00011111,B00011000,
      B00111000,B00011111,B00111000,
      B00111110,B00011000,B11111000,
      B00111111,B11111111,B11111000
    };
    const unsigned char status_fan2_bmp[] PROGMEM = {
      B00111111,B11111111,B11111000,
      B00111110,B00011000,B11111000,
      B00111000,B00011111,B00111000,
      B00110000,B00011111,B10011000,
      B00110100,B00011111,B00011000,
      B00101110,B00011110,B00001000,
      B00101111,B00011100,B00001000,
      B00101111,B10111000,B00001000,
      B00111111,B11111100,B00001000,
      B00111111,B11111111,B11111000,
      B00100000,B01111111,B11111000,
      B00100000,B00111011,B11101000,
      B00100000,B01110001,B11101000,
      B00100000,B11110000,B11101000,
      B00110001,B11110000,B01011000,
      B00110011,B11110000,B00011000,
      B00111001,B11110000,B00111000,
      B00111110,B00110000,B11111000,
      B00111111,B11111111,B11111000
    };

  #endif // !STATUS_ALT_FAN_BITMAP

#elif STATUS_FAN_FRAMES == 4

  #if ENABLED(STATUS_ALT_FAN_BITMAP)

    const unsigned char status_fan0_bmp[] PROGMEM = {
      B00000001,B11111111,B00000000,
      B00000110,B00000000,B11000000,
      B00001000,B00111111,B00100000,
      B00010000,B01111110,B00010000,
      B00010000,B01111100,B00010000,
      B00101000,B01111100,B00001000,
      B00101100,B00111000,B00001000,
      B00101111,B00111001,B11001000,
      B00101111,B11111111,B11101000,
      B00101111,B11000111,B11101000,
      B00101111,B11111111,B11101000,
      B00100111,B00111001,B11101000,
      B00100000,B00111000,B01101000,
      B00100000,B01111100,B00101000,
      B00010000,B01111100,B00010000,
      B00010000,B11111100,B00010000,
      B00001001,B11111000,B00100000,
      B00000110,B00000000,B11000000,
      B00000001,B11111111,B00000000
    };
    const unsigned char status_fan1_bmp[] PROGMEM = {
      B00000001,B11111111,B00000000,
      B00000110,B00000000,B11000000,
      B00001000,B00001111,B00100000,
      B00010100,B00011111,B11010000,
      B00010110,B00011111,B10010000,
      B00101111,B00011111,B00001000,
      B00101111,B10011110,B00001000,
      B00101111,B11111100,B00001000,
      B00101111,B11011100,B00001000,
      B00100111,B11101111,B11001000,
      B00100000,B01110111,B11101000,
      B00100000,B01111111,B11101000,
      B00100000,B11110011,B11101000,
      B00100001,B11110001,B11101000,
      B00010011,B11110000,B11010000,
      B00010111,B11110000,B01010000,
      B00001001,B11100000,B00100000,
      B00000110,B00000000,B11000000,
      B00000001,B11111111,B00000000
    };
    const unsigned char status_fan2_bmp[] PROGMEM = {
      B00000001,B11111111,B00000000,
      B00000110,B10000000,B11000000,
      B00001001,B10000000,B00100000,
      B00010111,B10000001,B11010000,
      B00010111,B11000011,B11010000,
      B00100111,B11000111,B11101000,
      B00100011,B11000111,B11111000,
      B00100001,B11111111,B10001000,
      B00100000,B01101100,B00001000,
      B00100000,B01101100,B00001000,
      B00100000,B01101100,B00001000,
      B00100011,B11111111,B00001000,
      B00111111,B11000111,B10001000,
      B00101111,B11000111,B11001000,
      B00010111,B10000111,B11010000,
      B00010111,B00000011,B11010000,
      B00001000,B00000011,B00100000,
      B00000110,B00000010,B11000000,
      B00000001,B11111111,B00000000
    };
    const unsigned char status_fan3_bmp[] PROGMEM = {
      B00000001,B11111111,B00000000,
      B00000110,B00000000,B11000000,
      B00001001,B11110000,B00100000,
      B00010001,B11100000,B00010000,
      B00010001,B11100000,B00010000,
      B00100001,B11100001,B11101000,
      B00100000,B11110011,B11101000,
      B00100000,B01111111,B11101000,
      B00100000,B01110111,B11101000,
      B00101000,B11101110,B00101000,
      B00101111,B11011100,B00001000,
      B00101111,B11111100,B00001000,
      B00101111,B10011110,B00001000,
      B00101111,B00001111,B00001000,
      B00010000,B00001111,B00010000,
      B00010000,B00001111,B00010000,
      B00001000,B00011111,B00100000,
      B00000110,B00000000,B11000000,
      B00000001,B11111111,B00000000
    };

  #else // !STATUS_ALT_FAN_BITMAP

    const unsigned char status_fan0_bmp[] PROGMEM = {
      B00111111,B11111111,B11111000,
      B00111110,B00000000,B11111000,
      B00111000,B00111111,B00111000,
      B00110000,B01111110,B00011000,
      B00110000,B01111100,B00011000,
      B00101000,B01111100,B00001000,
      B00101100,B00111000,B00001000,
      B00101111,B00111001,B11001000,
      B00101111,B11111111,B11101000,
      B00101111,B11000111,B11101000,
      B00101111,B11111111,B11101000,
      B00100111,B00111001,B11101000,
      B00100000,B00111000,B01101000,
      B00100000,B01111100,B00101000,
      B00110000,B01111100,B00011000,
      B00110000,B11111100,B00011000,
      B00111001,B11111000,B00111000,
      B00111110,B00000000,B11111000,
      B00111111,B11111111,B11111000
    };
    const unsigned char status_fan1_bmp[] PROGMEM = {
      B00111111,B11111111,B11111000,
      B00111110,B00000000,B11111000,
      B00111000,B00001111,B00111000,
      B00110100,B00011111,B11011000,
      B00110110,B00011111,B10011000,
      B00101111,B00011111,B00001000,
      B00101111,B10011110,B00001000,
      B00101111,B11111100,B00001000,
      B00101111,B11011100,B00001000,
      B00100111,B11101111,B11001000,
      B00100000,B01110111,B11101000,
      B00100000,B01111111,B11101000,
      B00100000,B11110011,B11101000,
      B00100001,B11110001,B11101000,
      B00110011,B11110000,B11011000,
      B00110111,B11110000,B01011000,
      B00111001,B11100000,B00111000,
      B00111110,B00000000,B11111000,
      B00111111,B11111111,B11111000
    };
    const unsigned char status_fan2_bmp[] PROGMEM = {
      B00111111,B11111111,B11111000,
      B00111110,B10000000,B11111000,
      B00111001,B10000000,B00111000,
      B00110111,B10000001,B11011000,
      B00110111,B11000011,B11011000,
      B00100111,B11000111,B11101000,
      B00100011,B11000111,B11111000,
      B00100001,B11111111,B10001000,
      B00100000,B01101100,B00001000,
      B00100000,B01101100,B00001000,
      B00100000,B01101100,B00001000,
      B00100011,B11111111,B00001000,
      B00111111,B11000111,B10001000,
      B00101111,B11000111,B11001000,
      B00110111,B10000111,B11011000,
      B00110111,B00000011,B11011000,
      B00111000,B00000011,B00111000,
      B00111110,B00000010,B11111000,
      B00111111,B11111111,B11111000
    };
    const unsigned char status_fan3_bmp[] PROGMEM = {
      B00111111,B11111111,B11111000,
      B00111110,B00000000,B11111000,
      B00111001,B11110000,B00111000,
      B00110001,B11100000,B00011000,
      B00110001,B11100000,B00011000,
      B00100001,B11100001,B11101000,
      B00100000,B11110011,B11101000,
      B00100000,B01111111,B11101000,
      B00100000,B01110111,B11101000,
      B00101000,B11101110,B00101000,
      B00101111,B11011100,B00001000,
      B00101111,B11111100,B00001000,
      B00101111,B10011110,B00001000,
      B00101111,B00001111,B00001000,
      B00110000,B00001111,B00011000,
      B00110000,B00001111,B00011000,
      B00111000,B00011111,B00111000,
      B00111110,B00000000,B11111000,
      B00111111,B11111111,B11111000
    };

  #endif // !STATUS_ALT_FAN_BITMAP

#endif
