/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2020 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */
#pragma once

//
// lcd/dogm/status/cutter.h - Status Screen Laser / Spindle bitmaps
//

#define STATUS_CUTTER_WIDTH 24
#define STATUS_CUTTER_X     80

#if ENABLED(LASER_FEATURE)
  #ifdef STATUS_CUTTER_ANIM
    const unsigned char status_cutter_on_bmp[] PROGMEM = {
      B00000000,B00100100,B00000000,
      B00000000,B01100110,B00000000,
      B00000000,B11000011,B00000000,
      B00000001,B10011001,B10000000,
      B00000011,B00100100,B11000000,
      B00000000,B01000010,B00000000,
      B00000000,B01000010,B00000000,
      B00000011,B00100100,B11000000,
      B00000001,B10011001,B10000000,
      B00000000,B11000011,B00000000,
      B00000000,B01100110,B00000000,
      B00000000,B00100100,B00000000
    };
    const unsigned char status_cutter_bmp[] PROGMEM = {
      B00000000,B00100100,B00000000,
      B00000000,B01100110,B00000000,
      B00000000,B00000000,B00000000,
      B00000001,B00000000,B10000000,
      B00000011,B00000000,B11000000,
      B00000000,B00011000,B00000000,
      B00000000,B00011000,B00000000,
      B00000011,B00000000,B11000000,
      B00000001,B00000000,B10000000,
      B00000000,B00000000,B00000000,
      B00000000,B01100110,B00000000,
      B00000000,B00100100,B00000000
    };
  #else
    const unsigned char status_cutter_bmp[] PROGMEM = {
      B00000000,B00100100,B00000000,
      B00000000,B01100110,B00000000,
      B00000000,B11000011,B00000000,
      B00000001,B10000001,B10000000,
      B00000011,B00000000,B11000000,
      B00000000,B00000000,B00000000,
      B00000000,B00000000,B00000000,
      B00000011,B00000000,B11000000,
      B00000001,B10000001,B10000000,
      B00000000,B11000011,B00000000,
      B00000000,B01100110,B00000000,
      B00000000,B00100100,B00000000
    };
  #endif
#else
  #ifdef STATUS_CUTTER_ANIM
    const unsigned char status_cutter_on_bmp[] PROGMEM = {
      B00000001,B11111110,B10000000,
      B00000000,B11000000,B00000000,
      B00000001,B10000000,B10000000,
      B00000001,B00000000,B10000000,
      B00000001,B11111100,B10000000,
      B00000000,B11100000,B00000000,
      B00000001,B11000000,B10000000,
      B00000000,B10000001,B00000000,
      B00000000,B01111010,B00000000,
      B00000000,B00110100,B00000000,
      B00000000,B00011000,B00000000,
      B00000000,B00000000,B00000000
    };
    const unsigned char status_cutter_bmp[] PROGMEM = {
      B00000001,B11111110,B10000000,
      B00000000,B11000000,B00000000,
      B00000001,B10000000,B10000000,
      B00000001,B00000000,B10000000,
      B00000001,B11111100,B10000000,
      B00000000,B11100000,B00000000,
      B00000001,B11000000,B10000000,
      B00000000,B10000001,B00000000,
      B00000000,B01111010,B00000000,
      B00000000,B00110100,B00000000,
      B00000000,B00011000,B00000000,
      B00000000,B00000000,B00000000
    };
  #else
    const unsigned char status_cutter_bmp[] PROGMEM = {
      B00000001,B11000010,B10000000,
      B00000001,B00011100,B10000000,
      B00000000,B11100001,B00000000,
      B00000001,B00001110,B10000000,
      B00000001,B01110000,B10000000,
      B00000000,B10000111,B10000000,
      B00000001,B00111111,B10000000,
      B00000000,B11111111,B00000000,
      B00000000,B01111110,B00000000,
      B00000000,B00111100,B00000000,
      B00000000,B00011000,B00000000,
      B00000000,B00000000,B00000000
    };
  #endif
#endif
