# Unified 2.0 Firmware

Unified Firmware 2.0 is the latest easy to use firmware for select 3D printers and boards from TH3D Studio. Both 8 bit and 32 bit based machines/boards are supported thanks to being built on **Marlin 2.1.2**.

This firmware focuses on printers with their stock control boards and select aftermarket boards. If you have a 3rd party or other board installed in your machine that is not supported by this firmware it is recommended to use ["Vanilla" Marlin](https://marlinfw.org) on your machine.

## Where to download and how to use it

Always download the latest firmware releases from our Unified 2 Firmware website here: [UF2.TH3DStudio.com](http://uf2.th3dstudio.com)

This GitHub repository is for tracking code changes. We have a local script that updates the download packages on the Unified 2 Firmware website linked above.

**This is ONLY tested for use with VSCode with the PlatformIO extension. Arduino IDE is not tested or supported.**

## Technical Support & Bug Reporting

For best results getting help with configuration and troubleshooting, please use the following resources:

- [TH3D Discord](http://Discord.TH3DStudio.com)
- [TH3D Help Center](https://support.th3dstudio.com)
- [TH3D Customer Facebook Group](http://fbgroup.th3dstudio.com/)

## Versioning

Any version number changes indicate a new printer addition and/or core feature change. Version numbers with letters appended (ex: 2.24a) are ones with bugfixes or additions that only affect some configurations. Read the [release notes on a release](https://github.com/th3dstudio/UnifiedFirmware/releases) for full details on what has changed between releases.

## Bug Reporting

If you find bugs, report them to the TH3D Studio team here:  [Contact Us](https://www.th3dstudio.com/unified-2-firmware-bug-report-form/).

Issue queue is disabled because some people do not understand what a proper issue is. We have our own internal issue tracking system we use for our repo.

## Something missing? ##

Check the txt file called `Install Guides and STL Files.txt`.

## Credits

TH3D Unified 2 Firmware is built on top of Marlin 2 Firmware. Please donate to their dev team if you wish to make a donation. This project is done by TH3D Studio LLC to provide the 3D printing community with easy to use firmware and also enable ease of use with our products and other products on the market. Profits from our store allow our technical team to make projects like this available for free to the community.

The current Marlin dev team consists of:

 - Scott Lahteine [[@thinkyhead](https://github.com/thinkyhead)] - USA &nbsp; [Donate](http://www.thinkyhead.com/donate-to-marlin) / Flattr: [![Flattr Scott](http://api.flattr.com/button/flattr-badge-large.png)](https://flattr.com/submit/auto?user_id=thinkyhead&url=https://github.com/MarlinFirmware/Marlin&title=Marlin&language=&tags=github&category=software)
 - Roxanne Neufeld [[@Roxy-3D](https://github.com/Roxy-3D)] - USA
 - Chris Pepper [[@p3p](https://github.com/p3p)] - UK
 - Bob Kuhn [[@Bob-the-Kuhn](https://github.com/Bob-the-Kuhn)] - USA
 - João Brazio [[@jbrazio](https://github.com/jbrazio)] - Portugal
 - Erik van der Zalm [[@ErikZalm](https://github.com/ErikZalm)] - Netherlands &nbsp; [![Flattr Erik](http://api.flattr.com/button/flattr-badge-large.png)](https://flattr.com/submit/auto?user_id=ErikZalm&url=https://github.com/MarlinFirmware/Marlin&title=Marlin&language=&tags=github&category=software)

## Firmware License

Marlin and Unified 2 Firmware is published under the [GPL license](/LICENSE) because we believe in open development. The GPL comes with both rights and obligations. Whether you use Marlin firmware as the driver for your open or closed-source product, you must keep Marlin open, and you must provide your compatible Marlin source code to end users upon request. The most straightforward way to comply with the Marlin license is to make a fork of Marlin on Github, perform your modifications, and direct users to your modified fork.

While we can't prevent the use of this code in products (3D printers, CNC, etc.) that are closed source or crippled by a patent, we would prefer that you choose another firmware or, better yet, make your own.

## STL File License

Some STL files are licensed to only TH3D customers and not permitted for re-distrubution by other individuals or companies. License files are accompanied in the ZIP file/folder for STL files that have a separate license.
